# CaMIB: Reproducibility Instructions 

This repository provides the code to reproduce the results of the CaMIB model reported in our ICLR submission. 

## 1. Environment Setup

The model is implemented using PyTorch 1.13.1 with CUDA 11.6. We recommend running on an NVIDIA RTX A6000 GPU (48GB) or equivalent. All required Python packages are listed in `requirements.txt` and can be installed via:

```bash
pip install -r requirements.txt
```

## 2. Pre-trained Model

Download `deberta-v3-base` from HuggingFace and place it in the directory above the `2.Bert/` folder:

```
../2.Bert/deberta-v3-base
```

Ensure that the code points to this path:

```
parser.add_argument("--model", type=str, default="../2.Bert/deberta-v3-base")
```

## 3. Datasets

All datasets used (CMU-MOSI and CMU-MOSEI) are publicly available. Please follow the preprocessing scripts provided in the repository to prepare the data.

## 4. Running Experiments

Two bash scripts are provided to train and evaluate the model:

- **CMU-MOSI**:

```
bash mosi
```

- **CMU-MOSEI**:

```
bash mosei
```

These scripts will automatically load the data, initialize the model, and run the training and evaluation pipeline.

## 5. Notes

- Hyperparameters, random seeds, and training configurations are fully specified in the scripts to ensure reproducibility.
- This README provides all necessary instructions to fully reproduce the reported results.